/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.math.BigDecimal;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.codefilarete.stalactite.sql.statement.binder.AbstractParameterBindersITTest;
import org.codefilarete.stalactite.sql.statement.binder.DerbyParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.DerbyTypeMapping;
import org.codefilarete.stalactite.sql.test.DatabaseHelper;
import org.codefilarete.stalactite.sql.test.DerbyDatabaseHelper;
import org.codefilarete.stalactite.sql.test.DerbyInMemoryDataSource;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DerbyParameterBindersTest
extends AbstractParameterBindersITTest {
    public DataSource giveDataSource() {
        return new DerbyInMemoryDataSource();
    }

    protected DatabaseHelper giveDatabaseHelper() {
        return new DerbyDatabaseHelper();
    }

    @BeforeEach
    void createParameterBinderRegistry() {
        this.parameterBinderRegistry = new DerbyParameterBinderRegistry();
    }

    @BeforeEach
    void createJavaTypeToSqlTypeMapping() {
        this.javaTypeToSqlTypeMapping = new DerbyTypeMapping();
    }

    @Test
    void bigDecimalBinder() throws SQLException {
        BigDecimal nullInsertion = (BigDecimal)this.insertAndSelect(BigDecimal.class, null);
        Assertions.assertThat((BigDecimal)nullInsertion).isNull();
        this.clearSchema();
        BigDecimal real = (BigDecimal)this.insertAndSelect(BigDecimal.class, BigDecimal.valueOf(42.66));
        Assertions.assertThat((BigDecimal)real).isCloseTo(BigDecimal.valueOf(42.66), Offset.offset((Number)BigDecimal.valueOf(0.001)));
    }
}

